%                     Nonlinear System Toolbox 2008
%                          
% The Nonlinear Systems Toolbox is a package of MATLAB .m files for the 
% analysis and synthesis of nonlinear control systems described by polynomials. 
% Some of these .m files are implimented by .mex files.  Therefore the first step is 
% to mex and link these .mex files.  See how2mex___.m in the ToBeMexed folder.
% 
% There are eight .m files that are implimented by .mex files.  
% They are 
%     [h,nh]=cmp(f,nf,df,g,ng,dg,d)
%     [h,nh]=dd(f,nf,df,g,ng,dg,d)
%     [h,nh]=jcbn(f,nf,df,nj,d)
%     [h,nh]=mply(f,nf,df,g,ng,dg,d)
%     z=mon(x,n,d)
%     c=chuze(n,k)
%     m=crd(n,d)
%     m=crdsum(n,d0,d1) or m=crdsum(n,[d0 d1])
%     
% See the how2mex___.m files in the ToBeMexed folder.

%  CMP, DD and MPLY accept complex fields, that is, polynomial fields with complex coefficients,
%  but they require that F and G both be real or both be complex.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Contents

% SYMVF2POLYVF 	Maple script to compute the power series expansion 
%					of a vector field from its symbolic form.

% Functions for controller design
%
% CH_CRDS	Computes term by term changes of state and ouput 
% 				coordinates and feedback on a system.
% DSP		Computes term by term a dissipative feedback law.
% FBI   	Computes term by term the solution of the 
%			Francis-Byrnes-Isidori PDE of nonlinear regulation.
% FBK_LIN 	Computes term by term an approximately linearizing 
% 				coordinates and feedback.
% FH2F_H_	Computes term by term a change of coordinates and 
%				feedback which approximately transforms one 
%  				nonlinear system to another.
% HJB 		Computes the stationary solution of a parameterized 
% 				nonlinear optimal control problem via the term by
% 				term solution of the Hamilton-Jacobi-Bellman PDE. 
% HJI		Computes the stationary solution of a parameterized
% 		 		nonlinear differential game via the term by
% 				term solution of the Hamilton-Jacobi-Isaacs PDE.
% INV_MFD	Computes term by term an invariant manifold.
% MDL_MTCH	Computes term by term an optimal model matching
% 				feedforward and feedback control law.
% ZBV		Computes term by term a Lyapunov function.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Utility Functions
%
% CHUZE 	Computes binomial coefficients.
% CMP  		Composes polynomial vector fields.
% CMP_INV	Computes the inverse of a polynomial vector field
%				under composition.
% COLSUM	Computes the column sums of a matrix.
% CRD		Computes the number of homogeneous monomials of
% 				given degree.
% CRDSUM	Computes the number of homogeneous monomials of
% 				lower degree to higher degree.
% DD		Computes the directional derivative of one polynomial
%				vector field by another.
% JCBN		Computes the Jacobian of a polynomial vector field.
% MON 		Computes the value of the monomials of a vector.
% MPLY 		Computes the product of a polynomial matrix field and
%				a polynomial vector or matrix field.
% PRT		Extracts terms of desired degrees from 
%				a polynomial vector field.
% SHOWF		Displays dynamics in a labeled format.
% SHOWH		Displays the output map in a labeled format.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




% The basic data type is a vector field which is polynomial of
% arbitrary degree in a vector which is composed of an arbitrary
% number of subvectors. Of course, memory and speed limitations
% will implicitly restrict the degrees of the vector fields
% and dimensions of vectors. NST also works with
% polynomial matrix fields, polynomial higher order 
% tensor fields and complex fields

% Consider a nonlinear system of the form 
%  xdot = f(x,u) = f0 + f1(x,u) + f2(x,u) + f3(x,u) +...+ fd(x,u)
%  y    = h(x,u) = h0 + h1(x,u) + h2(x,u) + h3(x,u) +...+ hd(x,u)
% where f0 and h0 are nx1 and px1 vectors, f1(x,u) and h1(x,u)
% are nx1 and px1 vector fields, linear in the nx1 state vector x
% and the mx1 input vector u, f2(x,u) and h2(x,u) are quadratic
% in x and u, f3(x,u) and h3(x,u) are cubic in x and u, and
% fd(x,u) and hd(x,u) are homogeneous polynomials of degree d
% in x and u. The output vector y is px1.
% The linear part of the system, 
%      f1(x,u) = a*x + b*u
%      h1(x,u) = c*x + d*u
% is stored in the computer as the n by (n+m) and p by (n+m)
% matrices
%      f1 = [a b]    
%      h1 = [c d]

% A word about notation. On some machines, Matlab is not 
% case-sensitive so this version of the Nonlinear_System_Toolbox
% uses only lower case identifiers in executable statements.
% In particular, to describe a linear system, we use a,b,c,d
% instead of the more standard A,B,C,D.  Greek letters are
% abbreviated to the first two letters of their name, e.g.
% al for alpha, be for beta.  The one exception is pi which is
% the constant in MATLAB.  We use py instead. 
% The Nonlinear_System_Toolbox also follows the standard Matlab
% convention of capitalizing identifiers when they appear in
% comments within script files, so in comments, A,B,C,D refer to
% the matrices a,b,c,d appearing in executable statements.
% However in this file which consists solely of comments, we 
% henceforth adopt a hybrid convention, identifiers in displays
% will not be capitalized but will look exactly as they do in
% executable statements. Identifiers appearing in the body of the
% text will be capitalized as they are in comments.
 
% The above nonlinear system consists of the two vector fields
% which are stored as the two matrices of coefficients of the 
% monomials of X and U, in order of increasing degree. 
%     f = [f0 f1 f2 f3 ... fd]
%     h = [h0 h1 h2 h3 ... hd]
% The monomials are in block lexographic order described below.
% The number of distinct monomials of degree D in the Nx1 vector
% X and the Mx1 vector U is
%       n+m+d-1 choose d.
% This is readily computed by calling
%      crd(n+m,d) 
% or equivalently
%      chuze(n+m+d-1,d)
% The number of distinct monomials of degrees 0 thru D in X and U
% is the same as the number of distinct monomials of degree D
% in WUN, X and U  where WUN is a scalar variable, the constant 1.
% The number is
%       n+m+d choose d.
% Therefore the matrix F is N by CRD(N+M+1,D) and H is P by
% CRD(N+M+1,D). Given the numerical values of the matrices F,H
% and the vectors X,U, we obtain the values of the vector fields
% f(x,u) and h(x,u) by multiplying the matrices F and H by a
% column vector composed of all the distinct monomials of
% degrees 0 thru D in X and U.
% These monomials should be in block lexographic order which we
% now describe.

% The monomials of a single vector X to degree three in
% lexographic order are
%      [1; x; {x}^2; {x}^3]
% The notation "{ }^" does not exist in Matlab.
% For the n vector
%      x=[x(1) x(2)...x(n)]'
% it is defined as follows
%     {x}^2= [x(1)*x(1) x(1)*x(2)...x(1)*x(n)...
%			  x(2)*x(2)...x(2)*x(3)...x(n)*x(n)]'
%     {x}^3= [x(1)*x(1)*x(1) x(1)*x(1)*x(2)...x(1)*x(1)*x(n)...
%             x(1)*x(2)*x(2) x(1)*x(2)*x(3)...x(1)*x(n)*x(n)...
%             x(2)*x(2)*x(2)...x(2)*x(2)*x(n)...x(n)*x(n)*x(n)]'
% Higher powers are defined similarly so that the indices to the
% right change faster than those to the left.
% When X is N by 1 vector, the function 
%      mon(x,n,[dl du])
% returns the column vector 
%      [{x}^dl;...;{x}^du]

 
% The monomials of the composite vector [X;U] to degree three 
% in block lexographic order are
%      [1; x; u; {x}^2; {x}*{u}; {u}^2;...
%      {x}^3; {x}^2*{u}; {x}*{u}^2; {u}^3]
% The notation "{ }^" is as above and the notation "{ }*{ }"
% is as follows for
%      x=[x1...xn]' and u=[u1...um]'
%     {x}*{u}= [x(1)*u(1)...x(1)*u(m) x(2)*u(1)...x(n)*u(m)]'
%     {x}^2*{u}= [x(1)*x(1)*u(1)...x(1)*x(1)*u(m) x(1)*x(2)*u(1)...
%				  x(1)*x(2)*u(m)...x(2)*x(2)*u(1)...x(n)*x(n)*u(m)]'
%     {x}*{u}^2= [x(1)*u(1)*u(1) x(1)*u(1)*u(2)...x(1)*u(m)*u(m)...
%                 x(2)*u(1)*u(1) x(2)*u(1)*u(2)...x(n)*u(m)*u(m)]'
% Notice that the monomials are in order of increasing degree,
% within each degree they are in blocks of the same degree in X
% and the same degree in U, and within the blocks the indices to
% the right change faster than those to the left. We use the
% notation {X;U}^D to denote the homogeneous monomials of degree
% D in [X;U] and the notation {1;X;U}^D to denote the monomials
% in [X;U] from degree 0 to D. For example,
%      {x;u}= [x;u] 
%      {x;u}^2= [{x}^2; {x}*{u}; {u}^2]
%      {x;u}^3= [{x}^3; {x}^2*{u}; {x}*{u}^2; {u}^3]
%      {1;x;u}^3= [1; x; u; {x;u}^2; {x;u}^3]

% The monomials of the composite vector [X;U;Y] to degree three 
% in block lexographic order are 
%      {x;u;y}= [x;u;y]
%      {x;u;y}^2= [{x}^2; {x}*{u;y}; {u;y}^2]
%      {x;u;y}^3= [{x}^3; {x}^2*{u;y}; {x}*{u;y}^2; {u;y}^3]
%      {1;x;u;y}^3=[1; {x;u;y}; {x;u;y}^2; {x;u;y}^3]. 
% In general, if X1, X2,...XK are column vectors, the monomials
% of the composite vector [X1;X2;...;XK] to degree three in block
% lexographic order are defined recursively 
%      {1;x1;...;xk}^3= [1; x1; {x2;...;xk};...
%                        {x1}^2;...
%                        {x1}*{x2;...;xk};...
%                        {x2;...;xk}^2;...
%                        {x1}^3;...
%                        {x1}^2*{x2;...;xk};...
%                        {x1}*{x2;...;xk}^2;...
%                        {x2;...;xk}^3]
% The function
%      mon([x1;x2;...xk],[n1;...;nk],[dl du])
% computes the monomials of degrees DL thru DU in block
% lexographic order in [X1;X2;...;XK], which are column vectors
% of dimensions, [N1;...;NK]. 
% For example
%       {1;x1;...;xk}^3
% is computed by
%        mon([x1;x2;...xk],[n1;...;nk],[0 3])

% If the above nonlinear system is of degree 3, then the cubic
% vector field f(x,u) evaluated at [X;U] is
%         f*mon([x;u],[n;m],[0 3])
% If f(x,u) has no constant term, F=[F1 F2 F3], then the 
% evaluation at [X;U] is given by
%         f*mon([x;u],[n;m],[1 3])

% The matrix F can be thought of as representing a field f(x,u)
% which is polynomial of degrees 0 thru 3 in [X;U] or can be
% thought of as representing a field f(wun,x,u) which is
% homogeneous of degree 3 in [WUN;X;U]. When WUN=1, the values
% are the same, i.e.
%     f*mon([x;u],[n;m],[0 3])==f*mon([1;x;u],[1;n;m],[3 3])

% Note to users of earlier versions of the 
% Nonlinear_System_Toolbox.  In this version the ordering of 
% the quadratic and cubic monomials for a composite vector with
% three or more subvectors is different . Therefore for fields 
% like f2(x,u,y) or f3(x,u,y), the matrices F2 and F3 that 
% represent them in what was previously called "block reduced 
% form" are not identical with the matrices that represent
% them in block lexographic order in this version.

% The submatrices of F that contain the coefficients of the
% homogeneous parts of the field and can be extracted by
% using the function PRT(F,NF,DF,D) where NF contains the 
% dimensions of F, DF the degrees of F and D contains the degrees
% to be extracted. 

% Associated to each vector field, F, is a pair of matrices,
% NF and DF, containing the dimensions and degrees of F.
% The degree matrix, DF, is 1x2, 
%      df=[df(1,1) df(1,2)].
% The first entry, DF(1,1) is the degree of the lowest terms in F
% and the second, DF(1,2), is the degree of the highest terms in F.
% The matrix F must contain all the coeficients for all monomials
% from degree DF(1,1) to DF(1,2). This may require some zero fill.
% If the above nonlinear system is of degree 3 then
%        df = [0 3]
% If F does not contain constant terms,
%        xdot = f(x,u) = f1(x,u) + f2(x,u) + f3(x,u)
% then
%        f = [f1 f2 f3] 
%        df = [1 3]. 
% Notice that when homogenizing a vector field F whose lower
% degree is not 0, the coefficients for the missing degrees from
% 0 to DF(1,1)-1 must be added. These coefficients are all zero.

% The dimension matrix, NF, contains information about the
% dimensions of the value and argument of F.  For vector fields
% NF has two columns, for matrix fields NF has 3 columns.
% The value of a vector field F is a column vector which can be 
% composed of subvectors. The dimensions of these subvectors are
% stored in the first column of the dimension matrix, NF. The 
% argument of a vector field F is a column vector which can be
% composed of subvectors. The dimensions of these subvectors are
% stored in the last column of NF. The rest of nf is zero
% filled.  If F is a matrix field then the first two columns of
% NF contain the the row and column dimensions of sub-blocks of 
% the value of F and the last column contains the dimensions of
% the subvectors in the argument of F.  
% The information in NF is needed by the routines that
% compose two vector fields, CMP. that differentiate one vector
% field in the direction of another, DD, that multiply a matrix 
% field and a vector field, MLPY, and that compute the Jacobian
% of a vector field, JCBN.  See below

% For the above nonlinear system
%         nf= [n 0;n m]'
%         nh= [p 0;n m]'
% If we viewed [f(x,u);h(x,u)] as a single vector field
% represented by the matrix
%         fh= [f;h]
% then 
%         nfh= [n p;n m]'

% Occasionally it is desirable to view the subvectors in the 
% value and the argument of a vector field as subvectors of a
% single supervector. We denote this through the dimension 
% matrix. For example, we can consider the vector 
% field [f(x,u);h(x,u)] as a mapping from [x;u;y] to
% [x;u;y] defined by [x;u;y]-->[f(x,u);0;h(x,u)].
% This mapping is represented by the matrix
%         fh= [f;h]
% with dimensions 
%         nfh= [n 0 p;n m 0]'
% The 0 in the first column opposite the M in the second column
% indicates the M missing rows of fh. The 0 in the second
% column opposite the P in the first indicates many missing
% columns of FH, the coefficients of those monomials in [x;u;y]
% containing a factor from y. As needed, FH will be filled with
% rows and/or columns of zeros based of the information in nfh.
% Notice in contrast with missing intermediate degree terms which
% need to be accounted for by filling with zero coefficients,
% missing subvectors in the value and argument do not require
% filling in with zero coefficients but rather are denoted
% through the dimension matrix.

% We can consider the vector field f(x,u) as a
% mapping from [x;u] to [x;u] (more precisely, to [xdot;udot]) 
% defined by [x;u]-->[f(x,u);0]. If we wished to differentiate
% h(x,u) in the direction f(x,u), we should consider the argument
% and value of f and the argument of h as parts of a supervector,
% [x;u]. So
%           nf= [n 0;n m]'  
%           nh= [p 0;n m]'
% Since the value of h need not be part of the supervector [x;u],
% we could also let
%           nh= [0 p;n m]'
% but since the value of f is the first subvector of [x;u],
% we could not let
%           nf= [0 n;n m]'
% We can also let the supervector be [x;u;y] in which case
%           nf= [n 0 0;n m 0]'
%           nh= [0 0 p;n m 0]'

% The directional derivative of h(x,u) in the direction f(x,u)
% is computed by
%           dd(h,nh,dh,f,nf,df,d)
% The last parameter D=[D(1,1) D(1,2)] contains the lower and
% upper degrees of the directional derivative to be computed.

% Occasionally, we consider vector fields depending on external
% parameters such as
%  f(x,u,x_,u_) = f0 + f1(x,u,x_,u_) +...+ fd(x,u,x_,u_)
% where X_ and U_ are N_ by 1 and M_ by 1 vectors. 
% The matrix of coefficients
%       f = [f0 f1 f2 f3 ... fd]
% is an N by CRD(N+M+N_+M_+1,D) matrix. The column order
% corresponds to that of the monomials in [X;U;X_;U_] in block
% lexographic order. The dimensions and degrees of F are
%        nf= [n 0 0 0;n m n_ m_]'
%        df= [0 d]
% Suppose H is an N by CRD(N+M+1,D) matrix representing
%   h(x,u) = h0 + h1(x,u) + h2(x,u) + h3(x,u) +...+ hd(x,u)
%     h = [h0 h1 h2 h3 ... hd]
% If we wished to compute the directional derivative of h(x,u)
% in the direction f(x,u,x_,u_), we would call 
%        dd(h,nh,dh,f,nf,df,d)
% with 
%        nh= [p 0 0 0;n m 0 0]'
%        dh= [0 d]
% In summary when calling DD(H,NH,DH,F,NF,DF,D)
% the number of rows in NH and NF must be the same and for each 
% row, the nonzero entries in the last column of NH and the
% first and second columns of NF must agree.
% For more information, type HELP DD.

% If we wished to form the composition of h(x,u) following 
% f(x,u,x_,u_) (more precisely, [f(x,u,x_,u_);0]) we call
%           cmp(h,nh,dh,f,nf,df,d)
% For CMP the value of F and the argument of H must be the same.
% This means that the number of rows in NH and NF must be the
% same and for each row, the nonzero entries in the last column
% of NH and the first column of NF must agree.
% For more information, type HELP CMP.

% If we wished to form the Jacobian of h(x,u) with respect to x 
% we call
%             jcbn(h,nh,dh,nj,d)
% with
%            nh= [p 0;n m]'
%            nj= [n 0]'
% The number of rows in NH and NJ must be the same and for each
% row, the nonzero entries in the last column of NH and the
% column NJ must agree. The Jacobian is computed with respect to
% those subvectors with nonzero entries in NJ. To compute the
% Jacobian with respect to both X and U, let
%            nj= [n m]'
% If we called
%            jcbn(h,nh,dh,nj,d)
% with
%            nh= [p 0 0 0;n m 0 0]'
%            nj= [n 0 n_ 0]'
% then H would be zero-filled to represent the vector field
% h(x,u,x_) and the Jacobian with respect X and X_ is computed. 
% Because both NH(4,2) and NJ(4,1) are zero, H is not zero-filled
% to represent the vector field h(x,u,x_,u_). 
% The Jacobian of a vector field is a matrix field which is
% row-stacked and transposed to make a long vector field.  Row
% stacking is used because of our standing convention of ordering
% multi-indexed quantities so that the indices on the left move
% slower than those on the right.
% For more information, type HELP JCBN.

% Vector fields are distinguished from matrix fields by their
% dimension matrix. As we have discussed, the dimension matrix
% of a vector field has two columns, the dimensions of the
% subvectors of the value are in the first column and the
% dimensions of the subvectors of the argument are in the
% second column. 
% The dimension matrix of a matrix field has three columns.
% The value of a matrix field can be composed of submatrices.
% The row dimensions of the submatrices are in the first column
% of the dimension matrix and the column dimensions of the
% submatices are in the the second column of the dimension matrix.
% The third column contains the dimensions of the argument of 
% the matrix field.
% The function MPLY multiplies a polynomial matrix field with
% another polynomial matrix field or a polynomial vector field.

% A tensor field can be treated as a long vector field by reducing
% the multiple index associated with the value of the field to a
% single index through lexographic ordering. The standard
% convention is to let the indices to the right change faster
% than those to the left.  This is a generalizes the way 
% tensor fields of order two, i.e., matrix fields are treated.

% The basic functions DD, CMP, JCBN accept tensor fields
% wherever they make mathematical sense.
% In particular, JCBN takes a
% tensor field of order k to one of order k+1.
% The dimension matrix of a tensor field of order k has k+1
% columns. The value of a tensor field of order k is indexed by
% a k-tuple of indices. The first index of the k-tuple ranges
% over the components of subvectors whose dimensions are in the
% first column of the dimension matrix, the second index of
% the k-tuple ranges over the components of subvectors whose
% dimensions are in the second column of the dimension matrix, 
% and the k-th index of the k-tuple ranges over the components of
% subvectors whose dimensions are in the k-th column of the
% dimension matrix. The last column of the dimension matrix
% contains the dimensions of the argument of the tensor field.



				
